### Satisfaction with Democracy: When Government by the People brings Electoral Losers and Winners Together
# Code Lucas Leemann and Isabelle Stadelmann-Steffen
# First version: December 2018
# Final version: April 2021



load("Output/Data/Final_data.RData")
###########################################################################################################################
###########################################################################################################################

# re-scale for optimization
DATA2$VoterProp <- DATA2$VoterProp/100
DATA2$age <- DATA2$age/100
DATA2$Average <- DATA2$Average/2
DATA2$Average_nt <- DATA2$Average_nt/2

# Average: DD index with threat
# Average_nt: DD index WITHOUT threat

# To look at individual institutions
# Init:       Index on Initiative  
# Init_nt:    Index on Initiative WITHOUT threat
# Ref:        Index on optional referendum 
# Ref_nt:     Index on optional referendum WITHOUT threat


DATA2$country <- as.factor(DATA2$country.x)
DATA2$employed_cat <- as.factor(DATA2$employed)
DATA2$edu <- as.factor(DATA2$edu)


# Manipulate educ variable to have highest degree always as baseline
DATA2$edu<- relevel(DATA2$edu, ref = 6)

DATA3 <- DATA2[DATA2$country=="US",]
DATA4 <- DATA2[DATA2$country=="CH",]

table(DATA2$Average[DATA2$country=="AT"])
table(DATA2$Init[DATA2$country=="AT"])
table(DATA2$Ref[DATA2$country=="AT"])
# AT mandatory scores, that is why there is nothink on Init/Ref


DATA2$country <- relevel(DATA2$country, ref = "CH")
DATA2$subnatID <- DATA2$unitID

load("Data/PowerDiffusion.RData")

data_final <- data_final1
data_final$State <-   recode_factor(data_final$State, 
                                    `Basel-City`="Basel-City ",
                                    `Lower Austria` = "Niederoesterreich",
                                    `Higher Austria` = "Oberoesterreich",
                                    `Salzburg Land` = "Salzburg",
                                    `Styria` = "Steiermark",
                                    `Tyrol` = "Tirol",
                                    `Vienna` = "Wien",
                                    `Berne` = "Bern",
                                    `NeuchÃ¢tel` = "Neuchatel",
                                    `St Gallen` = "St Gall",
                                    `Baden-WÃ¼rttemberg` = "Baden-Wurttemberg",
                                    `Bavaria` = "Bayern",
                                    `Hesse` = "Hessen",
                                    `Meckl.-West Pomerania` = "Mecklenburg-Vorpommern",
                                    `Lower Saxony` = "Niedersachsen",
                                    `North Rhine-Westphalia` = "Nordrhein-Westfalen",
                                    `Rhineland Palatinate` = "Rheinland-Pfalz",
                                    `Schleswig Holstein` = "Schleswig-Holstein",
                                    `Saxony` = "Sachsen",
                                    `Saxony-Anhalt` = "Thuringen",
                                    `Thuringia` = "Sachsen-Anhalt",
                                    `Solothurn` = 'Soleure')






DATAL <- merge(DATA2,data_final,by="State")#, all=TRUE)
DATAL$PowerDiffusion <- DATAL$V2



###########################################################################################################################

# Variable overview

DATA3 <- DATA2
DATA3$employed_cat <- as.numeric(DATA2$employed_cat )
DATA3$edu <- as.numeric(DATA2$edu)

DATA.table <- DATA3 %>%
  select(satisfactionD, age, female, participation, employed_cat, edu, country,snDDI, Usage, VoterProp,winner)

names(DATA.table) <- c("Satisfaction with Democracy", "Age", "Female","Participated in Last National Election", 
                       "Employment Categories", "Education Categories", "Country", "Subnational Direct Democracy Index",
                       "Past DD Usage", "Share of Voters in Government", "Voted for Party in Government")



sink("Output/Tables and Plots/Table_A6.tex")
stargazer(DATA.table, omit.summary.stat = c("p25", "p75")) 
sink()



########################################################
### table 2


M1 <- clmm(ordered(satisfactionD)  ~  winner + age + I(age*age)+ female  + participation+
             factor(employed_cat) + (1|subnatID) + factor(edu)+  snDDI , data=DATA2)


M1.1 <- clmm(ordered(satisfactionD)  ~  winner + age + I(age*age)+ female  + participation+
             factor(employed_cat) + (1|subnatID) + factor(edu)+  snDDI + VoterProp, data=DATA2)

M2.1 <- clmm(ordered(satisfactionD)  ~  winner + age + I(age*age)+ female  + participation+
             factor(employed_cat) + (1|subnatID) + factor(edu)+ factor(country) + snDDI + VoterProp, data=DATA2)

M3.1 <- clmm(ordered(satisfactionD)  ~  winner + age + I(age*age)+ female  + participation+
             factor(employed_cat) + (1|subnatID) + factor(edu)+ factor(country)*snDDI  + VoterProp, data=DATA2)



texreg(list(M1, M1.1,M2.1,M3.1), omit.coef="edu|emplo", 
       custom.model.names=c("Model 1","Model 2","Model 3","Model 4"),
          custom.coef.map = list(#"age" = "Age", "I(age * age)" = "Age^2",
            #"female" = "Female", 
            "winner" = "Voted for Party Government",
            "snDDI" = "Direct Democracy",
            "VoterProp" = "Size of Majority",
            "factor(country)AT" = "Indicator AT",
            "factor(country)DE" = "Indicator GE",
            "factor(country)US" = "Indicator US",
            "factor(country)AT:snDDI" = "DD X Indicator AT",
            "factor(country)DE:snDDI" = "DD X Indicator GE",
            "factor(country)US:snDDI" = "DD X Indicator US",
            "1|2" = "\\tau_{1}",
            "2|3" = "\\tau_{2}",
            "3|4" = "\\tau_{3}"),
       file = "Output/Tables and Plots/Table_2.tex")




#### Significance Check
set.seed(123)
VV <- vcov(M3.1)[-27,-27]
BB <- coef(M3.1)
BETA <- mvrnorm(1000,BB,VV)
head(BETA)


B.at <- BETA[,22] + BETA[,24]
B.at <- round(quantile(B.at,c(0.025,.975)),2)
cat(B.at,file= "Output/Tables and Plots/Footnote_13_1.tex")

B.ge <- BETA[,22] + BETA[,25]
B.ge <- round(quantile(B.ge,c(0.025,.975)),2)
cat(B.ge ,file= "Output/Tables and Plots/Footnote_13_2.tex")

B.us <- BETA[,22] + BETA[,26]
B.us <- round(quantile(B.us,c(0.025,.975)),2)
cat(B.us ,file= "Output/Tables and Plots/Footnote_13_.3tex")








############################################################################
### Figure 2

sum.data <- aggregate(satisfactionD~subnatID+winner, mean, data=DATA2)

data1 <- reshape(data = sum.data,
                 v.names=c("satisfactionD"), 
                 timevar = "winner", 
                 direction = "wide",
                 idvar = "subnatID")

data1$satdiff <- data1[,3] - data1[,2]
VP <- unique(cbind(DATA2$unitID,DATA2$VoterProp,DATA2$country))
colnames(VP) <- c("subnatID","VoterProp","country")
data2 <- merge(data1,VP,by="subnatID")

colL <- rev(RColorBrewer::brewer.pal(4, "PuOr"))
colL <- alpha(colL,alpha=0.9)

oL <- order(data2$satdiff)
data2[oL,]
data3 <- aggregate(satdiff ~ country, mean, data=data2)
data4 <- aggregate(satdiff ~ country, sd, data=data2)
data4[,2] <- data4[,2]^2
data4$svar <- data4[,2]/c(26,9,16,50)
data4$ssd <- sqrt(data4$svar)

jpeg("Output/Tables and Plots/Fig_A3.jpeg",width=1200,height=600)
par(family="CMU Serif", mar= c(3.1, 2.1, 2.1, 0.1))
barplot(data2$satdiff[oL],col=colL[data2$country[oL]], ylim=c(-1,1.3), border=NA)
legend(2,1,c("Switzerland", "Austria", "Germany", "United States of America"),col = colL, pch=19,bty="n", cex=1.5)
x.dist <- c(8,6,15,7)
for (i in 1:4){
  segments(x.dist[i],data3[i,2],118,data3[i,2], col=colL[i])
}
text(0,data3[1,2]+0.02,"Switzerland", col=colL[1],pos = 4,cex=0.8)
text(0,data3[2,2]+0.02,"Austria", col=colL[2],pos = 4,cex=0.8)
text(0,data3[4,2]+0.02,"Germany", col=colL[4],pos = 4,cex=0.8)
text(0,data3[3,2]+0.02,"United States of America", col=colL[3],pos = 4,cex=0.8)


for (j in 1:4){

  rect(x.dist[j],
       data3[j,2]-data4$ssd[j],
       118,
       data3[j,2]+data4$ssd[j],
       col=rgb(as.vector(col2rgb(colL[j]))[1],
               as.vector(col2rgb(colL[j]))[2],
               as.vector(col2rgb(colL[j]))[3],
               50,maxColorValue = 255), border = NA)
}
dev.off()



########################################################
### table 3



M3L0 <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu) + factor(country) + snDDI*winner, data=DATA2)

M3L2 <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu)+ factor(country) + snDDI*winner+VoterProp, data=DATA2)

M3L3 <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu) + factor(country) + snDDI*winner+winner*VoterProp, data=DATA2)





texreg(list(M3L0,M3L2,M3L3),custom.coef.map = list("VoterProp" = "Share of Voters in Government",
                                                   "snDDI" = "Direct Democracy",
                                                   "winner" = "Voted for Party Government",
                                                   "snDDI:winner" = "DD X Voted for Gov",
                                                   "winner:snDDI" = "DD X Voted for Gov",
                                                   # "winner:VoterProp" = "Voted for Gov X Share of Voters in Government",
                                                   "snDDI:VoterProp" = "DD X Size of Majority",
                                                   "winner:VoterProp" = "Voted for Gov X Size of Majority",
                                                   "1|2" = "\\tau_{1}",
                                                   "2|3" = "\\tau_{2}",
                                                   "3|4" = "\\tau_{3}",
                                                   "unitID"= "SubNatID"),
       custom.model.names=c("Model 5","Model 6","Model 7"),
       file = "Output/Tables and Plots/Table_3.tex")






#######

# Plot Winner/Looser

coef(M3L2)
VoterProp <- .1
x.loser <- cbind(.15,     #age          
                 0.0225,  #I(age * age) 
             0,     #female         
             0,     #participation
             0,     #factor(employed_cat)2
             0,     #factor(employed_cat)3
             0,     #factor(employed_cat)4
             0,     #factor(employed_cat)5     
             0,     #factor(edu)0             
             0,     #factor(edu)1
             0,     #factor(edu)2
             0,     #factor(edu)3
             0,     #factor(edu)4          
             0,     #factor(edu)6     
             0,     #factor(country)AT     
             0,     #factor(country)DE     
             0,     #factor(country)US
             seq(0,2,length.out = 60),     #snDDI                
             0,     #winner             
             VoterProp,     #VoterProp          
             0)    #snDDI:winner 

x.winner <- cbind(.15,     #age          
                  0.0225,  #I(age * age) 
             0,     #female         
             0,     #participation
             0,     #factor(employed_cat)2
             0,     #factor(employed_cat)3
             0,     #factor(employed_cat)4
             0,     #factor(employed_cat)5     
             0,     #factor(edu)0             
             0,     #factor(edu)1
             0,     #factor(edu)2
             0,     #factor(edu)3
             0,     #factor(edu)4          
             0,     #factor(edu)6     
             0,     #factor(country)AT     
             0,     #factor(country)DE     
             0,     #factor(country)US
             seq(0,2,length.out = 60),     #snDDI                
             1,     #winner             
             VoterProp,     #VoterProp          
             seq(0,2,length.out = 60))    #snDDI:winner 
                
VV <- vcov(M3L2)
BB <- coef(M3L2)
BETA <- mvrnorm(1000,BB[-c(1:3,25)],VV[-c(1:3,25:28),-c(1:3,25:28)])
y.lat.loser <-   BETA%*%t(x.loser)

BETA <- mvrnorm(1000,BB[-c(1:3,25)],VV[-c(1:3,25:28),-c(1:3,25:28)])
y.lat.winner <-   BETA%*%t(x.winner)


y.loser <- apply(y.lat.loser,2 , invlogit)
y.winner <- apply(y.lat.winner,2 , invlogit)

DD <- seq(0,2,length.out = 60)

qu.lo <- matrix(NA,3,60)
qu.wi <- matrix(NA,3,60)

for (i in 1:60){
  qu.lo[,i] <- quantile(y.loser[,i],c(0.025,.5,.975))
  qu.wi[,i] <- quantile(y.winner[,i],c(0.025,.5,.975))
}


y.loser1 <- y.loser
y.winner1 <- y.winner

y.loser <- apply(y.loser,2,sort)
y.winner <- apply(y.winner,2,sort)
                        
y.loser <- y.loser[-c(1:25,975:1000),]           
y.winner <- y.winner[-c(1:25,975:1000),]           


jpeg("Output/Tables and Plots/Fig_2.jpeg",width=1200,height=1000,pointsize = 20)
#pdf("Plots/DDGap.pdf",width=12,height=8)
par(family="CMU Serif", mfrow=c(2,1))
plot(DD,colMeans(y.winner), type="l", ylim=c(0.3,.8),
     ylab="Probability of Being Satisfied with Democracy",
     xlab="Extent of Direct Democratic Institutions",
     col=colL[4], bty="n", lwd=3)
#points(DD, qu.wi[1,], col="blue", lty=1, type="l")
#points(DD, qu.wi[3,], col="blue", lty=1, type="l")
# for (i in 1:60){
#   segments(DD[i],qu.wi[1,i],DD[i],qu.wi[3,i], col="blue")
# }

points(DD, colMeans(y.loser), type="l", col=colL[1], lwd=3)
#points(DD, qu.lo[1,], col="red", lty=1, type="l")
#points(DD, qu.lo[3,], col="red", lty=1, type="l")
# for (i in 1:60){
#   segments(DD[i],qu.lo[1,i],DD[i],qu.lo[3,i], col="red")
# }

for (i in 1:949){
  points(DD, y.winner[i,], col=rgb(as.vector(col2rgb(colL[4]))[1],
                                   as.vector(col2rgb(colL[4]))[2],
                                   as.vector(col2rgb(colL[4]))[3],
                                   5,maxColorValue = 255),
         type="l", lwd=2)
}

points(DD, colMeans(y.loser), type="l", col=colL[1], lwd=3)
for (i in 1:949){
  points(DD, y.loser[i,], col=rgb(as.vector(col2rgb(colL[1]))[1],
                                  as.vector(col2rgb(colL[1]))[2],
                                  as.vector(col2rgb(colL[1]))[3],
                                  5,maxColorValue = 255),
         type="l", lwd=2)
}


legend(0,.4,legend=c("Winners", "Losers"), lwd=6,col=c(colL[4],colL[1]),
       bty="n")

rug(unique(DATA2$snDDI), lwd=4, col="grey")




delta.y <- y.winner1 - y.loser1
outi <- t(apply(delta.y,2,quantile,c(0.025,.5,.975)))

dim(delta.y)
delta.y  <- apply(delta.y ,2,sort)
delta.y <- delta.y[-c(1:25,976:1000),]

plot(DD,colMeans(delta.y), ylim=c(-0.1,.3), 
     ylab="Difference in Predicted Probability", bty="n",
     xlab="Extent of Direct Democratic Institutions",
     type="l", lwd=3, col=rgb(as.vector(col2rgb(colL[3]))[1],
                              as.vector(col2rgb(colL[3]))[2],
                              as.vector(col2rgb(colL[3]))[3],
                              255,maxColorValue = 255))

for (i in 1:950){
  points(DD, delta.y[i,], type="l", lwd=3,
         col=rgb(as.vector(col2rgb(colL[3]))[1],
                 as.vector(col2rgb(colL[3]))[2],
                 as.vector(col2rgb(colL[3]))[3],
                 5,maxColorValue = 255))
}

#points(DD,outi[,1],type="l",col=rgb(205,0,255,255,maxColorValue = 255))
#points(DD,outi[,3],type="l",col=rgb(205,0,255,255,maxColorValue = 255))

abline(h=0,lty=2)


dev.off()






################################################################################
# Robustness Review (is satisfaction measure driven...)


M3L0.rr <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu) + factor(country) + 
                 snDDI*winner + (snDDI*winner | country), data=DATA2)

M3L2.rr <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu)+ factor(country) + 
                 snDDI*winner+VoterProp + (snDDI*winner|country), data=DATA2)

M3L3.rr <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu) + factor(country) + 
                 snDDI*winner+winner*VoterProp + (snDDI*winner|country), data=DATA2)


texreg(list(M3L0,M3L2,M3L3),custom.coef.map = list("VoterProp" = "Share of Voters in Government",
                                                   "snDDI" = "Direct Democracy",
                                                   "winner" = "Voted for Party Government",
                                                   "snDDI:winner" = "DD X Voted for Gov",
                                                   "winner:snDDI" = "DD X Voted for Gov",
                                                   # "winner:VoterProp" = "Voted for Gov X Share of Voters in Government",
                                                   "snDDI:VoterProp" = "DD X Size of Majority",
                                                   "winner:VoterProp" = "Voted for Gov X Size of Majority",
                                                   "1|2" = "\\tau_{1}",
                                                   "2|3" = "\\tau_{2}",
                                                   "3|4" = "\\tau_{3}",
                                                   "unitID"= "SubNatID"),
       custom.model.names=c("Model 5","Model 6","Model 7"),
       file = "Output/Tables and Plots/Table_A17.tex")





################################################################################
# For review 



M3L3 <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu) + factor(country) + snDDI*winner+winner*VoterProp, data=DATA2)

M3L3.init <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
                    factor(employed_cat) + (1+winner|subnatID) + factor(edu) + factor(country) + Init*winner+winner*VoterProp, data=DATA2)

M3L3.ref <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
                   factor(employed_cat) + (1+winner|subnatID) + factor(edu) + factor(country) + Ref*winner+winner*VoterProp, data=DATA2)

M3L3.manref <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
                   factor(employed_cat) + (1+winner|subnatID) + factor(edu) + factor(country) + ManRef*winner+winner*VoterProp, data=DATA2)



texreg(list(M3L3,M3L3.ref,M3L3.init,M3L3.manref),custom.coef.map = list("VoterProp" = "Share of Voters in Government",
                                                            "snDDI" = "Direct Democracy",
                                                            "Ref" = "Just Optional Referendum Score",
                                                            "Init" = "Just Initiative Score",
                                                            "ManRef" = "Just Mandatory Referendum Score",
                                                            "winner" = "Voted for Party Government",
                                                            "snDDI:winner" = "DD X Voted for Gov",
                                                            "Ref:winner" = "Referendum X Voted for Gov",
                                                            "Init:winner" = "Initiative X Voted for Gov",
                                                            "ManRef:winner" = "Mandatory Referendum X Voted for Gov",
                                                            # "winner:VoterProp" = "Voted for Gov X Share of Voters in Government",
                                                            "snDDI:VoterProp" = "DD X Share of Voters in Government",
                                                            "winner:VoterProp" = "Voted for Gov X Share of Voters in Government",
                                                            "1|2" = "\\tau_{1}",
                                                            "2|3" = "\\tau_{2}",
                                                            "3|4" = "\\tau_{3}",
                                                            "unitID"= "SubNatID"),
       custom.model.names=c("Model 5","Model 6","Model 7","Model 7"),
       file = "Output/Tables and Plots/Table_A16.tex")



################################################################################
################################################################################
# Count variable

DATA2$InstCount <- as.numeric(DATA2$Init>0) + as.numeric(DATA2$Ref>0) + as.numeric(DATA2$ManRef>0)


M3L3.count <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
                     factor(employed_cat) + (1+winner|subnatID) + factor(edu) + factor(country) + InstCount*winner+winner*VoterProp, data=DATA2)

summary(M3L3.count)



texreg(list(M3L3,M3L3.count),custom.coef.map = list("VoterProp" = "Share of Voters in Government",
                                                    "snDDI" = "Direct Democracy",
                                                    "InstCount" = "Raw Count of DD Institutions",
                                                    "winner" = "Voted for Party Government",
                                                    "snDDI:winner" = "DD X Voted for Gov",
                                                    "InstCount:winner" = "Raw Count X Voted for Gov",
                                                    # "winner:VoterProp" = "Voted for Gov X Share of Voters in Government",
                                                    "snDDI:VoterProp" = "DD X Share of Voters in Government",
                                                    "winner:VoterProp" = "Voted for Gov X Share of Voters in Government",
                                                    "1|2" = "\\tau_{1}",
                                                    "2|3" = "\\tau_{2}",
                                                    "3|4" = "\\tau_{3}",
                                                    "unitID"= "SubNatID"),
       custom.model.names=c("Model Index","Model Raw Count"),
       file = "Output/Tables and Plots/Table_A15.tex")



################################################################################
################################################################################

# R O B U S T N E S     S E C T I O N

################################################################################
################################################################################




load("Output/Data/IndexUSCHATDE.Rdata")
tab1 <- DD.data[,c(14,1,2,4,6,17)]
colnames(tab1) <- c("Country", "Unit","Initiative", "Referendum","Mandatory Referendum", "Total snDDI")


sink("Output/Tables and Plots/Table_A8_and_A9.tex")
print(xtable(tab1), include.rownames=FALSE)
sink()



##################################################################################################################################
########## USAGE Models


M1 <- clmm(ordered(satisfactionD)  ~  winner + age + I(age*age)+ female  + participation+
             factor(employed_cat) + (1|subnatID) + factor(edu)+  Usage , data=DATA2)

M2 <- clmm(ordered(satisfactionD)  ~  winner + age + I(age*age)+ female  + participation+
             factor(employed_cat) + (1|subnatID) + factor(edu) + Usage  + VoterProp, data=DATA2)

M3 <- clmm(ordered(satisfactionD)  ~  winner + age + I(age*age)+ female  + participation+
             factor(employed_cat) + (1|subnatID) + factor(edu)+ factor(country)+ Usage  + VoterProp, data=DATA2)

M4 <- clmm(ordered(satisfactionD)  ~  winner + age + I(age*age)+ female  + participation+
             factor(employed_cat) + (1|subnatID) + factor(edu)+ factor(country)*Usage + VoterProp , data=DATA2)

texreg(list(M1,M2,M3,M4), omit.coef="edu|emplo", 
       custom.model.names=c("Model 1-u","Model 2-u","Model 3-u","Model 4-u"),
       custom.coef.map = list(#"age" = "Age", "I(age * age)" = "Age^2",
         #"female" = "Female", 
         "winner" = "Voted for Party Government",
         "Usage" = "Direct Democracy Use",
         "VoterProp" = "Size of Majority",
         "VoterProp:Usage" = "DD Use x Size of Majority",
         #"factor(country)AT" = "Indicator AT",
         #"factor(country)DE" = "Indicator GE",
         #"factor(country)US" = "Indicator US",
         "factor(country)AT:Usage" = "DD Use X Indicator AT",
         "factor(country)DE:Usage" = "DD Use X Indicator GE",
         "factor(country)US:Usage" = "DD Use X Indicator US",
         "1|2" = "\\tau_{1}",
         "2|3" = "\\tau_{2}",
         "3|4" = "\\tau_{3}"),
       file="Output/Tables and Plots/Table_A12.tex")







M3L1 <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu) + factor(country) + Usage*winner, data=DATA2)

M3L2 <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu)+ factor(country) + Usage*winner + VoterProp, data=DATA2)

M3L3 <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu) + factor(country) + Usage*winner+winner*VoterProp, data=DATA2)





texreg(list(M3L1,M3L2,M3L3),custom.coef.map = list("VoterProp" = "Size of Majority",
                                                   "Usage" = "Direct Democracy Use",
                                                   "winner" = "Voted for Party Government",
                                                   "Usage:winner" = "DD Use X Voted for Gov",
                                                   "winner:Usage" = "DD Use X Voted for Gov",
                                                   "winner:VoterProp" = "DD Use X Size of Majority",
                                                   "1|2" = "\\tau_{1}",
                                                   "2|3" = "\\tau_{2}",
                                                   "3|4" = "\\tau_{3}",
                                                   "unitID"= "SubNatID"),
       custom.model.names=c("Model 5-u","Model 6-u","Model 7-u"),
       file="Output/Tables and Plots/Table_A13.tex")

#####



# Alternative Measure for Power Sharing

#PROBLEM: 97 CASES BUT SHOULD BE 98
M3L0 <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu) + factor(country) + snDDI*winner , data=DATAL)#, #threshold = "equidistant")
          

M3L2 <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu)+ factor(country) + snDDI*winner + PowerDiffusion, data=DATAL)

M3L3 <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu) + factor(country) + snDDI*winner + winner*PowerDiffusion, data=DATAL)




texreg(list(M3L0,M3L2,M3L3),custom.coef.map = list("PowerDiffusion" = "Power Sharing",
                                                   "snDDI" = "Direct Democracy",
                                                   "winner" = "Voted for Party Government",
                                                   "snDDI:winner" = "DD X Voted for Gov",
                                                   "winner:snDDI" = "DD X Voted for Gov",
                                                   # "winner:VoterProp" = "Voted for Gov X Share of Voters in Government",
                                                   "snDDI:PowerDiffusion" = "DD X Power Sharing",
                                                   "winner:PowerDiffusion" = "Voted for Gov X Power Sharing",
                                                   "1|2" = "\\tau_{1}",
                                                   "2|3" = "\\tau_{2}",
                                                   "3|4" = "\\tau_{3}",
                                                   "unitID"= "SubNatID"),
       custom.model.names=c("Model 5","Model 6","Model 7"),
       file = "Output/Tables and Plots/Table_A14.tex")



###################################################################




########################################################
### table 2 Replication without some Swiss Cantons (single-member districts)

# AI, AR, GL, NW, OW, UR
'%!in%' <- function(x,y)!('%in%'(x,y))

DATA.purged <- DATA2[DATA2$unitID %!in% c(115,116,108,106,107,104),]






M1 <- clmm(ordered(satisfactionD)  ~  winner + age + I(age*age)+ female  + participation+
             factor(employed_cat) + (1|subnatID) + factor(edu)+  snDDI , data=DATA.purged)


M1.1 <- clmm(ordered(satisfactionD)  ~  winner + age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1|subnatID) + factor(edu)+  snDDI + VoterProp, data=DATA.purged)


M2.1 <- clmm(ordered(satisfactionD)  ~  winner + age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1|subnatID) + factor(edu)+ factor(country) + snDDI + VoterProp, data=DATA.purged)


M3.1 <- clmm(ordered(satisfactionD)  ~  winner + age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1|subnatID) + factor(edu)+ factor(country)*snDDI  + VoterProp, data=DATA.purged)




texreg(list(M1, M1.1,M2.1,M3.1), omit.coef="edu|emplo", 
       custom.model.names=c("Model 1","Model 2","Model 3","Model 4"),
       custom.coef.map = list(#"age" = "Age", "I(age * age)" = "Age^2",
         #"female" = "Female", 
         "winner" = "Voted for Party Government",
         "snDDI" = "Direct Democracy",
         "VoterProp" = "Size of Majority",
         "factor(country)AT" = "Indicator AT",
         "factor(country)DE" = "Indicator GE",
         "factor(country)US" = "Indicator US",
         "factor(country)AT:snDDI" = "DD X Indicator AT",
         "factor(country)DE:snDDI" = "DD X Indicator GE",
         "factor(country)US:snDDI" = "DD X Indicator US",
         "1|2" = "\\tau_{1}",
         "2|3" = "\\tau_{2}",
         "3|4" = "\\tau_{3}"),
       file = "Output/Tables and Plots/Table_A10.tex")




########################################################
### table 3 Replication without some Swiss Cantons (single-member districts)


M3L0 <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu) + factor(country) + snDDI*winner, data=DATA.purged)

M3L2 <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu)+ factor(country) + snDDI*winner+VoterProp, data=DATA.purged)

M3L3 <- clmm(ordered(satisfactionD)  ~  age + I(age*age)+ female  + participation+
               factor(employed_cat) + (1+winner|subnatID) + factor(edu) + factor(country) + snDDI*winner+winner*VoterProp, data=DATA.purged)




texreg(list(M3L0,M3L2,M3L3),custom.coef.map = list("VoterProp" = "Size of Majority",
                                                   "snDDI" = "Direct Democracy",
                                                   "winner" = "Voted for Party Government",
                                                   "snDDI:winner" = "DD X Voted for Gov",
                                                   "winner:snDDI" = "DD X Voted for Gov",
                                                   # "winner:VoterProp" = "Voted for Gov X Share of Voters in Government",
                                                   "snDDI:VoterProp" = "DD X Size of Majority",
                                                   "winner:VoterProp" = "Voted for Gov X Size of Majority",
                                                   "1|2" = "\\tau_{1}",
                                                   "2|3" = "\\tau_{2}",
                                                   "3|4" = "\\tau_{3}",
                                                   "unitID"= "SubNatID"),
       custom.model.names=c("Model 5-r","Model 6-r","Model 7-r"),
       file = "Output/Tables and Plots/Table_A11.tex")


##########################################################################################################


DATA2$snDDI.cat <- NA
DATA2$snDDI.cat[DATA2$snDDI < 0.5] <- 1
DATA2$snDDI.cat[DATA2$snDDI > 0.49 & DATA2$snDDI < 1] <- 2
DATA2$snDDI.cat[DATA2$snDDI > 0.99 & DATA2$snDDI < 1.5 ] <- 3
DATA2$snDDI.cat[DATA2$snDDI > 1.5] <- 4

summary(DATA2$satisfactionD[DATA2$snDDI.cat==1 & DATA2$winner == 0])
summary(DATA2$satisfactionD[DATA2$snDDI.cat==1 & DATA2$winner == 1])

summary(DATA2$satisfactionD[DATA2$snDDI.cat==2 & DATA2$winner == 0])
summary(DATA2$satisfactionD[DATA2$snDDI.cat==2 & DATA2$winner == 1])

summary(DATA2$satisfactionD[DATA2$snDDI.cat==3 & DATA2$winner == 0])
summary(DATA2$satisfactionD[DATA2$snDDI.cat==3 & DATA2$winner == 1])

summary(DATA2$satisfactionD[DATA2$snDDI.cat==4 & DATA2$winner == 0])
summary(DATA2$satisfactionD[DATA2$snDDI.cat==4 & DATA2$winner == 1])

catcher <- matrix(NA,5,4)

for (i in sort(unique(DATA2$snDDI.cat))){
  print(i)
  print(summary(DATA2$satisfactionD[DATA2$snDDI.cat==i & DATA2$winner == 0]))
  catcher[1,i] <- mean(DATA2$satisfactionD[DATA2$snDDI.cat==i & DATA2$winner == 0],na.rm = TRUE)
  print(summary(DATA2$satisfactionD[DATA2$snDDI.cat==i & DATA2$winner == 1]))
  catcher[2,i] <- mean(DATA2$satisfactionD[DATA2$snDDI.cat==i & DATA2$winner == 1],na.rm = TRUE)
  catcher[3,i] <- length(DATA2$satisfactionD[DATA2$snDDI.cat==i]) - sum(is.na(DATA2$satisfactionD[DATA2$snDDI.cat==i]))
  catcher[4,i] <- var(DATA2$satisfactionD[DATA2$snDDI.cat==i & DATA2$winner == 0],na.rm = TRUE)
  catcher[5,i] <- var(DATA2$satisfactionD[DATA2$snDDI.cat==i & DATA2$winner == 1],na.rm = TRUE)
}

jpeg("Output/Tables and Plots/Fig_A8.jpeg",width=1440,height=800,pointsize = 20)
par(family="CMU Serif")
plot(c(1:4), catcher[1,], pch=19, ylim=c(2,3.5), type="l",
     xlab="Direct Democracy Bins",
     ylab="Average Satisfaction",
     bty="n",
     xaxt="n",
     col=rgb(80,80,80,100,maxColorValue = 255))
points(c(1:4), catcher[1,], pch=19, cex=2)
for(i in 1:4){
  a <- catcher[1,i] - 2.57*sqrt(catcher[4,i]/catcher[3,i])
  b <- catcher[1,i] + 2.57*sqrt(catcher[4,i]/catcher[3,i])
  segments(i,a,i,b, lwd=2)
}
points(c(1:4), catcher[2,], cex=2)
points(c(1:4), catcher[2,], type="l",
       col=rgb(80,80,80,100,maxColorValue = 255))
for(i in 1:4){
  a <- catcher[2,i] - 2.57*sqrt(catcher[5,i]/catcher[3,i])
  b <- catcher[2,i] + 2.57*sqrt(catcher[5,i]/catcher[3,i])
  segments(i,a,i,b, lwd=2)
}
axis(1,c(1:4),labels = c("<0.5","0.5-1","1-1.5",">1.5"))
legend("topright",pch=c(1,19),
       legend=c("Electoral Winners","Electoral Losers"),
       bty="n")
dev.off()

# PLOT 1 #################################################################################################


load("Output/Data/IndexUSCHATDE.Rdata")


#### Plots

colorL <-rev(RColorBrewer::brewer.pal(4, "PuOr"))[c(4,2,3,1)]
#colorL <- rep("grey",4)
countryL <- c("United States", "Austria", "Germany", "Switzerland")




jpeg("Output/Tables and Plots/Fig_A7.jpeg",width=1440,height=800)
par(family="CMU Serif", mai=c(1,0.5,0.5,0.5))
fit <- princomp(DD.data[,c(6,2,4,7)], cor=TRUE)
#plot(fit,type="lines")  
biplot(fit, col=c(colL[1],colL[3],colL[2]), lwd=2)
dev.off()
